/*	cflsbuf.c	1.10	83/05/13	*/

#include <stdio.h>
#include "cpmio.h"
#include "cpmfio.h"

/*
 * Flush a full block to floppy disk file
 * (these routines are never called unless a full block is
 * to be written)
 * Create a new extent if required
 */

cpm_file_flush(C_FILE *fptr)
{

	int	it; 

	if (!(fptr->c_flag & WRITE)) {
		fprintf(stderr, "no write access");
		return (EOF);
	}
	fptr->c_seccnt += fptr->cpmfs->blksiz/fptr->cpmfs->seclth;
	/* caution: blockno() might evaluate its argument twice */
	if (!cpm_putblock(fptr->cpmfs, blockno(fptr,fptr->c_blk), fptr->c_base, -1)) {
	    return (EOF);
	}
	fptr->c_blk++;
	if (fptr->c_blk == (fptr->cpmfs->use16bitptrs? 8: 16)) {
		fptr->c_dirp->blkcnt =  (char) 0x80;
		cpm_savedir(fptr->cpmfs);
		/* create new extent */
		if ((it = cpm_creext(fptr->cpmfs,fptr->c_ext)) < 0) {
			return (EOF);
		}
		fptr->c_dirp = fptr->cpmfs->dirbuf+it;
		fptr->c_ext  = it;
		fptr->c_blk  = 0;
		fptr->c_seccnt = 0;
		fptr->c_extno++;
		fptr->c_dirp->extno= fptr->c_extno;
	}
	fptr->c_buf = fptr->c_base;
	fptr->c_cnt = fptr->cpmfs->blksiz;
	if ((it = cpm_alloc(fptr->cpmfs)) == '\0') {
		return (EOF);
	}
	if (fptr->cpmfs->use16bitptrs) {
		fptr->c_dirp->pointers[2*fptr->c_blk] = it & 0xff;
		fptr->c_dirp->pointers[2*fptr->c_blk+1] = (it >> 8) & 0xff;
	} else
		fptr->c_dirp->pointers[fptr->c_blk] = it;

	return (0);
}

cpm_file_flsbuf(c, fptr)
	register C_FILE *fptr;
{
	if (cpm_file_flush(fptr) == EOF)
		return (EOF);
	*(fptr->c_buf++) = c;
	fptr->c_cnt--;
	return (c);
}

/*
 * move the contents of 'buf' into the cpm block buffer,
 * flush the buffer if full (for binary file transfers)
 */

cpm_file_write(fptr, buf, cnt)
	register C_FILE *fptr;
	char *buf;
{
	int i = cnt;

	while (i-- > 0) {
		*(fptr->c_buf++) = *(buf++);
		if (--fptr->c_cnt == 0)
			if (cpm_file_flush(fptr) == EOF)
				return (EOF);
	}

	return (cnt);
}
